﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Globalization;
using System.Runtime.Versioning;
using System.Threading;
using System.Reflection;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        string ścieżkaPliku = "";
        bool tekstZmieniony = false;

        public Form1()
        {
            InitializeComponent();
        }

        #region Metody pomocnicze
        private void ustalTytułOkna()
        {
            this.Text =
                Path.GetFileName(ścieżkaPliku) +
                (tekstZmieniony ? "*" : "") +
                " - Notatnik.NET";
        }

        private bool zapiszDoPlikuJako() 
        {
            //if (!string.IsNullOrWhiteSpace(ścieżkaPliku))
            if (File.Exists(ścieżkaPliku))
            {
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            else
            {
                saveFileDialog1.FileName = "";
            }
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.ReadOnly = false;
                File.WriteAllLines(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
                tekstZmieniony = false;
                ustalTytułOkna();
                return true;
            }
            else return false;
        }

        private bool zapiszDoPliku()
        {
            try
            {
                if (!File.Exists(ścieżkaPliku)) return zapiszDoPlikuJako();
                else
                {
                    File.WriteAllLines(ścieżkaPliku, textBox1.Lines);
                    tekstZmieniony = false;
                    ustalTytułOkna();
                    return true;
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(
                    "Błąd podczas zapisywania: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
                return false;
            }
        }

        private bool spytajCzyZapisać()
        {
            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany w pliku " + ścieżkaPliku + "?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);
            switch (dr)
            {
                case DialogResult.Yes:
                    return zapiszDoPliku();
                case DialogResult.No:
                    return true;
                case DialogResult.Cancel:
                    return false;
                default:
                    throw new Exception("Nieprzewidziana wartość zmiennej 'dr'");
            }
        }

        private void wyczyśćNotatnik()
        {
            textBox1.Text = "";
            ścieżkaPliku = "";
            tekstZmieniony = false;
            ustalTytułOkna();
        }
        #endregion

        #region Metody zdarzeniowe
        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                openFileDialog1.FileName = ścieżkaPliku;
                if (openFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    /*textBox1.Lines = File.ReadAllLines(openFileDialog1.FileName);
                    textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
                    ścieżkaPliku = openFileDialog1.FileName;                    
                    tekstZmieniony = false;
                    ustalTytułOkna();*/
                    OtworzZPliku(openFileDialog1.FileName);
                }
            }
            catch(Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku: " + exc.Message,
                    this.Text,
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawartość przeniesiona do osobnej metody
            zapiszDoPlikuJako();
        }

        private void zmieńKolorTła(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if(fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zapiszDoPliku();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) wyczyśćNotatnik();
            else if (spytajCzyZapisać()) wyczyśćNotatnik();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            tekstZmieniony = true;
            ustalTytułOkna();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!tekstZmieniony) Close();
            else if (spytajCzyZapisać()) Close();
        }

        #endregion
        //PRACA DOMOWA
        private void Form1_Load(object sender, EventArgs e)
        {
            if (Properties.Settings.Default.Form1_Location.X == 0 || Properties.Settings.Default.Form1_Location.Y == 0)
                this.Location = new Point(50, 50);
            else
                this.Location = Properties.Settings.Default.Form1_Location;

            if (Properties.Settings.Default.Form1_Size.Height == 0 || Properties.Settings.Default.Form1_Size.Width == 0)
                this.Size = new Size(640, 640);
            else
                this.Size = Properties.Settings.Default.Form1_Size;

            if (Properties.Settings.Default.Form1_FileOpen != "")
            {
                try
                {
                    OtworzZPliku(Properties.Settings.Default.Form1_FileOpen);
                }
                catch (Exception exc)
                {
                    MessageBox.Show(
                   "Błąd odczytu pliku: " + exc.Message,
                   this.Text,
                   MessageBoxButtons.OK,
                   MessageBoxIcon.Error);
                }
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.Form1_Location = Location;
            Properties.Settings.Default.Form1_Size = Size;
            Properties.Settings.Default.Form1_FileOpen = ścieżkaPliku;
            Properties.Settings.Default.Save();
        }

        private void OtworzZPliku(string sciezka)
        {
            textBox1.Lines = File.ReadAllLines(sciezka);
            if (openFileDialog1.ReadOnlyChecked == true)
                textBox1.ReadOnly = openFileDialog1.ReadOnlyChecked;
            ścieżkaPliku = sciezka;
            tekstZmieniony = false;
            ustalTytułOkna();
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DateTime dt = DateTime.Now;
            textBox1.SelectedText = "Nazwa" + "\t\t" + "Godzina";
            textBox1.SelectedText = Environment.NewLine;
            string tab;

            CultureInfo[] cultures = CultureInfo.GetCultures(CultureTypes.AllCultures);
            foreach (CultureInfo culture in cultures)
            {
                textBox1.SelectedText = CultureInfo.CreateSpecificCulture(culture.Name).ToString();
                tab = CultureInfo.CreateSpecificCulture(culture.Name).ToString();
    
                if (tab.Length > 6)
                    tab = "\t";
                else
                    tab = "\t\t";

                textBox1.SelectedText = tab;
                textBox1.SelectedText = dt.ToString(CultureInfo.CreateSpecificCulture(culture.Name));
                textBox1.SelectedText = Environment.NewLine;
            }
            //string gd = dt.ToString();
            
        }
    }
}
